/*
 * Decompiled with CFR 0.152.
 */
package io.github.jodlodi.twilighttweaks.spawner_remnant;

import io.github.jodlodi.twilighttweaks.TwilightTweaks;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.data.tags.EntityTagGenerator;

@ParametersAreNonnullByDefault
public class BossSpawnerRemnantBlockEntity
extends BlockEntity {
    private String spawnerLocation;
    public boolean active = false;
    public int reSpawnerTick = 0;

    public BossSpawnerRemnantBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TwilightTweaks.BOSS_SPAWNER_REMNANT_ENTITY.get(), pos, state);
    }

    public void setSpawnerLocation(String spawnerLocation) {
        this.spawnerLocation = spawnerLocation;
    }

    @Nullable
    public Block getSpawnerBlock() {
        if (this.spawnerLocation != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.spawnerLocation));
        }
        return null;
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128359_("spawnerLocation", this.spawnerLocation);
        compoundTag.m_128379_("active", this.active);
        compoundTag.m_128405_("reSpawnerTick", this.reSpawnerTick);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.spawnerLocation = compoundTag.m_128461_("spawnerLocation");
        this.active = compoundTag.m_128471_("active");
        this.reSpawnerTick = compoundTag.m_128451_("reSpawnerTick");
    }

    public static void shtick(Level level, BlockPos pos, BlockState state, BossSpawnerRemnantBlockEntity te) {
        if (te.active) {
            Block spawner;
            if (te.reSpawnerTick > 0) {
                ++te.reSpawnerTick;
            }
            if (level.f_46443_) {
                int tick = Math.min(100, te.reSpawnerTick);
                double distance = (double)tick * 0.01 * 0.7;
                Vec3 center = Vec3.m_82512_((Vec3i)pos);
                double maxX = center.f_82479_ + distance;
                double minX = center.f_82479_ - distance;
                double maxY = center.f_82480_ + distance;
                double minY = center.f_82480_ - distance;
                double maxZ = center.f_82481_ + distance;
                double minZ = center.f_82481_ - distance;
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), maxY, maxZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), maxY, minZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), minY, maxZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), minY, minZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, maxX, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), maxZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, maxX, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), minZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, minX, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), maxZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, minX, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), minZ);
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, maxX, maxY, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, maxX, minY, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, minX, maxY, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, minX, minY, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
                BossSpawnerRemnantBlockEntity.addRandomStationaryParticle(level, tick, BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82479_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82480_, distance), BossSpawnerRemnantBlockEntity.randomOffset(level.f_46441_, center.f_82481_, distance));
            } else if (te.reSpawnerTick >= 120 && (spawner = te.getSpawnerBlock()) != null) {
                level.m_46597_(pos, Block.m_49897_((BlockState)state, (BlockState)spawner.m_49966_(), (LevelAccessor)level, (BlockPos)pos));
                level.m_46961_(pos.m_7495_(), true);
            }
        } else if (level.m_6443_(Mob.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)40.0, (double)40.0, (double)40.0), entity -> entity.m_6095_().m_204039_(EntityTagGenerator.BOSSES)).isEmpty()) {
            te.active = true;
        }
    }

    private static void addRandomStationaryParticle(Level level, int chance, double x, double y, double z) {
        if (level.f_46441_.m_188503_(100 - Math.min(99, chance)) <= chance) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175829_, x, y, z, 0.0, 0.0, 0.0);
            if (level.f_46441_.m_188499_()) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    private static double randomOffset(RandomSource random, double point, double distance) {
        return point + random.m_188500_() * distance * (double)(random.m_188499_() ? 1 : -1);
    }
}

