/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.Provider;
import java.util.Vector;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.SunProvider;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5ProxyCredential;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;

public final class Krb5MechFactory
implements MechanismFactory {
    private static final boolean DEBUG = Krb5Util.DEBUG;
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_KRB5_MECH_OID = Krb5MechFactory.createOid("1.2.840.113554.1.2.2");
    static final Oid NT_GSS_KRB5_PRINCIPAL = Krb5MechFactory.createOid("1.2.840.113554.1.2.2.1");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME, NT_GSS_KRB5_PRINCIPAL};
    private final GSSCaller caller;

    private static Krb5CredElement getCredFromSubject(GSSNameSpi gSSNameSpi, boolean bl) throws GSSException {
        Krb5CredElement krb5CredElement;
        Vector<Krb5InitCredential> vector = GSSUtil.searchSubject(gSSNameSpi, GSS_KRB5_MECH_OID, bl, bl ? Krb5InitCredential.class : Krb5AcceptCredential.class);
        Krb5CredElement krb5CredElement2 = krb5CredElement = vector == null || vector.isEmpty() ? null : (Krb5CredElement)vector.firstElement();
        if (krb5CredElement != null) {
            if (bl) {
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)krb5CredElement.getName());
            } else {
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)krb5CredElement.getName(), gSSNameSpi);
            }
        }
        return krb5CredElement;
    }

    public Krb5MechFactory(GSSCaller gSSCaller) {
        this.caller = gSSCaller;
    }

    @Override
    public GSSNameSpi getNameElement(String string, Oid oid) throws GSSException {
        return Krb5NameElement.getInstance(string, oid);
    }

    @Override
    public GSSNameSpi getNameElement(byte[] byArray, Oid oid) throws GSSException {
        return Krb5NameElement.getInstance(new String(byArray), oid);
    }

    @Override
    public GSSCredentialSpi getCredentialElement(GSSNameSpi gSSNameSpi, int n, int n2, int n3) throws GSSException {
        Krb5CredElement krb5CredElement;
        if (gSSNameSpi != null && !(gSSNameSpi instanceof Krb5NameElement)) {
            gSSNameSpi = Krb5NameElement.getInstance(gSSNameSpi.toString(), gSSNameSpi.getStringNameType());
        }
        if ((krb5CredElement = Krb5MechFactory.getCredFromSubject(gSSNameSpi, n3 != 2)) == null) {
            if (n3 == 1 || n3 == 0) {
                krb5CredElement = Krb5InitCredential.getInstance(this.caller, (Krb5NameElement)gSSNameSpi, n);
                krb5CredElement = Krb5ProxyCredential.tryImpersonation(this.caller, (Krb5InitCredential)krb5CredElement);
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)krb5CredElement.getName());
            } else if (n3 == 2) {
                krb5CredElement = Krb5AcceptCredential.getInstance(this.caller, (Krb5NameElement)gSSNameSpi);
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)krb5CredElement.getName(), gSSNameSpi);
            } else {
                throw new GSSException(11, -1, "Unknown usage mode requested");
            }
        }
        return krb5CredElement;
    }

    public static void checkInitCredPermission(Krb5NameElement krb5NameElement) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = krb5NameElement.getKrb5PrincipalName().getRealmAsString();
            String string2 = new String("krbtgt/" + string + '@' + string);
            ServicePermission servicePermission = new ServicePermission(string2, "initiate");
            try {
                securityManager.checkPermission(servicePermission);
            }
            catch (SecurityException securityException) {
                if (DEBUG) {
                    System.out.println("Permission to initiatekerberos init credential" + securityException.getMessage());
                }
                throw securityException;
            }
        }
    }

    public static void checkAcceptCredPermission(Krb5NameElement krb5NameElement, GSSNameSpi gSSNameSpi) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && krb5NameElement != null) {
            ServicePermission servicePermission = new ServicePermission(krb5NameElement.getKrb5PrincipalName().getName(), "accept");
            try {
                securityManager.checkPermission(servicePermission);
            }
            catch (SecurityException securityException) {
                SecurityException securityException2;
                if (gSSNameSpi == null) {
                    securityException2 = new SecurityException("No permission to acquire Kerberos accept credential");
                }
                throw securityException2;
            }
        }
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSNameSpi gSSNameSpi, GSSCredentialSpi gSSCredentialSpi, int n) throws GSSException {
        if (gSSNameSpi != null && !(gSSNameSpi instanceof Krb5NameElement)) {
            gSSNameSpi = Krb5NameElement.getInstance(gSSNameSpi.toString(), gSSNameSpi.getStringNameType());
        }
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = this.getCredentialElement(null, n, 0, 1);
        }
        return new Krb5Context(this.caller, (Krb5NameElement)gSSNameSpi, (Krb5CredElement)gSSCredentialSpi, n);
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        if (gSSCredentialSpi == null) {
            gSSCredentialSpi = this.getCredentialElement(null, 0, Integer.MAX_VALUE, 2);
        }
        return new Krb5Context(this.caller, (Krb5CredElement)gSSCredentialSpi);
    }

    @Override
    public GSSContextSpi getMechanismContext(byte[] byArray) throws GSSException {
        return new Krb5Context(this.caller, byArray);
    }

    @Override
    public final Oid getMechanismOid() {
        return GSS_KRB5_MECH_OID;
    }

    @Override
    public Provider getProvider() {
        return PROVIDER;
    }

    @Override
    public Oid[] getNameTypes() {
        return nameTypes;
    }

    private static Oid createOid(String string) {
        Oid oid = null;
        try {
            oid = new Oid(string);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return oid;
    }
}

